/// <reference path="./internal_*.d.ts" />
declare namespace dev.engine_room.flywheel.backend.mixin {
    interface LevelRendererAccessor {
        abstract flywheel$getTicks(): number;
        (): number;
    }
    type LevelRendererAccessor_ = LevelRendererAccessor;
}
declare namespace org.w3c.dom {
    interface Node {
        abstract getPrefix(): string;
        abstract getFirstChild(): this;
        abstract getLastChild(): this;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract cloneNode(arg0: boolean): this;
        abstract normalize(): void;
        abstract getOwnerDocument(): Internal.Document;
        abstract hasChildNodes(): boolean;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract hasAttributes(): boolean;
        abstract removeChild(arg0: org.w3c.dom.Node_): this;
        abstract getNodeValue(): string;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract appendChild(arg0: org.w3c.dom.Node_): this;
        abstract getNamespaceURI(): string;
        abstract getLocalName(): string;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): this;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): this;
        abstract lookupPrefix(arg0: string): string;
        abstract setPrefix(arg0: string): void;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getTextContent(): string;
        abstract getChildNodes(): Internal.NodeList;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract getNodeType(): number;
        abstract setNodeValue(arg0: string): void;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract getNextSibling(): this;
        abstract getUserData(arg0: string): any;
        abstract getParentNode(): this;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): this;
        get prefix(): string
        get firstChild(): org.w3c.dom.Node
        get lastChild(): org.w3c.dom.Node
        get ownerDocument(): Internal.Document
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        get namespaceURI(): string
        get localName(): string
        get previousSibling(): org.w3c.dom.Node
        set prefix(arg0: string)
        get textContent(): string
        get childNodes(): Internal.NodeList
        get attributes(): Internal.NamedNodeMap
        get nodeType(): number
        set nodeValue(arg0: string)
        get baseURI(): string
        get nextSibling(): org.w3c.dom.Node
        get parentNode(): org.w3c.dom.Node
        readonly DOCUMENT_POSITION_CONTAINS: 8;
        readonly ELEMENT_NODE: 1;
        readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 32;
        readonly TEXT_NODE: 3;
        readonly PROCESSING_INSTRUCTION_NODE: 7;
        readonly CDATA_SECTION_NODE: 4;
        readonly ENTITY_NODE: 6;
        readonly COMMENT_NODE: 8;
        readonly NOTATION_NODE: 12;
        readonly DOCUMENT_POSITION_DISCONNECTED: 1;
        readonly DOCUMENT_POSITION_PRECEDING: 2;
        readonly ENTITY_REFERENCE_NODE: 5;
        readonly DOCUMENT_POSITION_FOLLOWING: 4;
        readonly ATTRIBUTE_NODE: 2;
        readonly DOCUMENT_FRAGMENT_NODE: 11;
        readonly DOCUMENT_POSITION_CONTAINED_BY: 16;
        readonly DOCUMENT_NODE: 9;
        readonly DOCUMENT_TYPE_NODE: 10;
    }
    type Node_ = Node;
}
declare namespace Internal {
    class ControllerBlock$ControllerRenderType extends Internal.Enum<Internal.ControllerBlock$ControllerRenderType> implements Internal.StringRepresentable {
        static values(): Internal.ControllerBlock$ControllerRenderType[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.ControllerBlock$ControllerRenderType;
        get serializedName(): string
        static readonly column_x: Internal.ControllerBlock$ControllerRenderType;
        static readonly inside_a: Internal.ControllerBlock$ControllerRenderType;
        static readonly inside_b: Internal.ControllerBlock$ControllerRenderType;
        static readonly column_y: Internal.ControllerBlock$ControllerRenderType;
        static readonly block: Internal.ControllerBlock$ControllerRenderType;
        static readonly column_z: Internal.ControllerBlock$ControllerRenderType;
    }
    type ControllerBlock$ControllerRenderType_ = "block" | "column_x" | "column_y" | "column_z" | "inside_b" | ControllerBlock$ControllerRenderType | "inside_a";
    class PortableCellItem extends Internal.AbstractPortableCell implements Internal.IBasicCellItem {
        constructor(keyType: Internal.AEKeyType_, totalTypes: number, menuType: Internal.MenuType_<any>, tier: Internal.StorageTier_, props: Internal.Item$Properties_, defaultColor: number)
        getIdleDrain(): number;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        setDigSpeed(speed: number): void;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        getBytes(cellItem: Internal.ItemStack_): number;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getTotalTypes(cellItem: Internal.ItemStack_): number;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        getKeyType(): Internal.AEKeyType;
        addCellInformationToTooltip(is: Internal.ItemStack_, lines: Internal.List_<net.minecraft.network.chat.Component>): void;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getBytesPerType(cellItem: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        getCellTooltipImage(is: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isBlackListed(cellItem: Internal.ItemStack_, requestedAddition: Internal.AEKey_): boolean;
        isStorageCell(i: Internal.ItemStack_): boolean;
        getTier(): Internal.StorageTier;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        isEditable(is: Internal.ItemStack_): boolean;
        storableInStorageCell(): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        get idleDrain(): number
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get keyType(): Internal.AEKeyType
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get tier(): Internal.StorageTier
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type PortableCellItem_ = PortableCellItem;
    class MagnetUpgradeItem extends Internal.UpgradeItemBase<Internal.MagnetUpgradeWrapper> {
        constructor(radius: Internal.IntSupplier_, filterSlotCount: Internal.IntSupplier_, upgradeTypeLimitConfig: any_)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        getRadius(): number;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getInventoryColumnsTaken(): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getType(): Internal.UpgradeType<Internal.MagnetUpgradeWrapper>;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        get filterSlotCount(): number
        get radius(): number
        set attackSpeed(attackSpeed: number)
        get inventoryColumnsTaken(): number
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get type(): Internal.UpgradeType<Internal.MagnetUpgradeWrapper>
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static readonly TYPE: Internal.UpgradeType<Internal.MagnetUpgradeWrapper>;
    }
    type MagnetUpgradeItem_ = MagnetUpgradeItem;
    class ClientboundBlockEventPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getBlock(): Internal.Block;
        isSkippable(): boolean;
        getB0(): number;
        getB1(): number;
        get pos(): BlockPos
        get block(): Internal.Block
        get skippable(): boolean
        get b0(): number
        get b1(): number
    }
    type ClientboundBlockEventPacket_ = ClientboundBlockEventPacket;
    class MobEffectInstance implements Internal.MobEffectInstanceExtensions, Internal.MobEffectInstanceAccessor, Internal.Comparable<Internal.MobEffectInstance>, Internal.AccessorMobEffectInstance {
        constructor($$0: Internal.MobEffect_, $$1: number)
        constructor($$0: Internal.MobEffect_)
        constructor($$0: Internal.MobEffect_, $$1: number, $$2: number, $$3: boolean, $$4: boolean, $$5: boolean, $$6: Internal.MobEffectInstance_, $$7: Internal.Optional_<Internal.MobEffectInstance$FactorData>)
        constructor($$0: Internal.MobEffect_, $$1: number, $$2: number, $$3: boolean, $$4: boolean, $$5: boolean)
        constructor($$0: Internal.MobEffect_, $$1: number, $$2: number)
        constructor($$0: Internal.MobEffect_, $$1: number, $$2: number, $$3: boolean, $$4: boolean)
        constructor($$0: Internal.MobEffectInstance_)
        bookshelf$getHiddenEffect(): this;
        addCurativeItem(stack: Internal.ItemStack_): void;
        save($$0: Internal.CompoundTag_): Internal.CompoundTag;
        compareTo(arg0: any): number;
        getEffect(): Internal.MobEffect;
        showIcon(): boolean;
        isCurativeItem(stack: Internal.ItemStack_): boolean;
        getDescriptionId(): string;
        isVisible(): boolean;
        bookshelf$tickDownDuration(): number;
        isInfiniteDuration(): boolean;
        create$getHiddenEffect(): this;
        getCurativeItems(): Internal.List<any>;
        applyEffect($$0: Internal.LivingEntity_): void;
        setDuration(arg0: number): void;
        isAmbient(): boolean;
        mapDuration($$0: Internal.Int2IntFunction_): number;
        writeCurativeItems(nbt: Internal.CompoundTag_): void;
        static load($$0: Internal.CompoundTag_): Internal.MobEffectInstance;
        getAmplifier(): number;
        compareTo($$0: Internal.MobEffectInstance_): number;
        getFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        bookshelf$setHiddenEffect(arg0: Internal.MobEffectInstance_): void;
        endsWithin($$0: number): boolean;
        update($$0: Internal.MobEffectInstance_): boolean;
        tick($$0: Internal.LivingEntity_, $$1: Internal.Runnable_): boolean;
        setCurativeItems(curativeItems: Internal.List_<any>): void;
        getDuration(): number;
        get effect(): Internal.MobEffect
        get descriptionId(): string
        get visible(): boolean
        get infiniteDuration(): boolean
        get curativeItems(): Internal.List<any>
        set duration(arg0: number)
        get ambient(): boolean
        get amplifier(): number
        get factorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>
        set curativeItems(curativeItems: Internal.List_<any>)
        get duration(): number
        duration: number;
        static readonly INFINITE_DURATION: -1;
    }
    type MobEffectInstance_ = MobEffectInstance;
    interface IObserveTileEntity {
        abstract onObserved(arg0: Internal.ServerPlayer_, arg1: Internal.ObservePacket_): void;
        (arg0: Internal.ServerPlayer, arg1: Internal.ObservePacket): void;
    }
    type IObserveTileEntity_ = IObserveTileEntity;
    interface MaterialVariantId {
        create(id: Internal.MaterialId_, variant: string): this;
        abstract getId(): Internal.MaterialId;
        convertJson(json: Internal.JsonElement_, key: string): this;
        matchesVariant(other: Internal.MaterialVariant_): boolean;
        abstract matchesVariant(arg0: Internal.MaterialVariantId_): boolean;
        abstract hasVariant(): boolean;
        tryParse(string: string): this;
        matchesVariant(stack: Internal.ItemStack_): boolean;
        abstract getVariant(): string;
        create(domain: string, path: string, variant: string): this;
        fromJson(json: Internal.JsonObject_, key: string): this;
        parse(text: string): this;
        sameVariant(other: Internal.MaterialVariantId_): boolean;
        abstract getLocation(arg0: string): ResourceLocation;
        get id(): Internal.MaterialId
        get variant(): string
    }
    type MaterialVariantId_ = MaterialVariantId;
    class SpringConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.FluidState_, $$1: boolean, $$2: number, $$3: number, $$4: Internal.HolderSet_<Internal.Block>)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.SpringConfiguration>;
        readonly requiresBlockBelow: boolean;
        readonly state: Internal.FluidState;
        readonly validBlocks: Internal.HolderSet<Internal.Block>;
        readonly rockCount: number;
        readonly holeCount: number;
    }
    type SpringConfiguration_ = SpringConfiguration;
    class MouseEvent extends Internal.InputEvent {
        constructor(arg0: Internal.Component_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: boolean, arg10: number)
        constructor(arg0: Internal.Component_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: boolean)
        constructor(arg0: Internal.Component_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: boolean, arg8: number)
        getPoint(): Internal.Point;
        static getMouseModifiersText(arg0: number): string;
        getLocationOnScreen(): Internal.Point;
        getX(): number;
        translatePoint(arg0: number, arg1: number): void;
        getButton(): number;
        getY(): number;
        getXOnScreen(): number;
        getYOnScreen(): number;
        isPopupTrigger(): boolean;
        getClickCount(): number;
        get point(): Internal.Point
        get locationOnScreen(): Internal.Point
        get x(): number
        get button(): number
        get y(): number
        get XOnScreen(): number
        get YOnScreen(): number
        get popupTrigger(): boolean
        get clickCount(): number
        static readonly MOUSE_CLICKED: 500;
        static readonly MOUSE_PRESSED: 501;
        static readonly MOUSE_MOVED: 503;
        static readonly MOUSE_ENTERED: 504;
        static readonly MOUSE_DRAGGED: 506;
        static readonly MOUSE_FIRST: 500;
        static readonly BUTTON1: 1;
        static readonly MOUSE_WHEEL: 507;
        static readonly BUTTON3: 3;
        static readonly BUTTON2: 2;
        static readonly MOUSE_LAST: 507;
        static readonly MOUSE_RELEASED: 502;
        static readonly MOUSE_EXITED: 505;
        static readonly NOBUTTON: 0;
    }
    type MouseEvent_ = MouseEvent;
    class DimensionalBlockPos {
        constructor(level: Internal.Level_, x: number, y: number, z: number)
        constructor(blockentity: Internal.BlockEntity_)
        constructor(coordinate: Internal.DimensionalBlockPos_)
        constructor(level: Internal.Level_, pos: BlockPos_)
        getLevel(): Internal.Level;
        getPos(): BlockPos;
        isInWorld(level: Internal.LevelAccessor_): boolean;
        get level(): Internal.Level
        get pos(): BlockPos
    }
    type DimensionalBlockPos_ = DimensionalBlockPos;
    class VeinRecipeJS extends Internal.RecipeJS {
        constructor()
        biomeBlacklist(tag: string): this;
        alwaysFinite(): this;
        placement(spacing: number, separation: number, salt: number): this;
        reduction(freqReduction: string): this;
        alwaysInfinite(): this;
        priority(priority: number): this;
        spread(spread: string): this;
        biomeWhitelist(tag: string): this;
        defaultFinite(): this;
        veinSize(min: number, max: number): this;
        getMod(): string;
        get mod(): string
        static readonly ICON: Internal.RecipeKey<OutputItem>;
        static readonly NAME: Internal.RecipeKey<net.minecraft.network.chat.Component>;
        static readonly SCHEMA: Internal.RecipeSchema;
    }
    type VeinRecipeJS_ = VeinRecipeJS;
    class AmethystClusterBlock extends Internal.AmethystBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: number, $$1: number, $$2: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type AmethystClusterBlock_ = AmethystClusterBlock;
    class FrogportBlockEntity extends Internal.PackagePortBlockEntity implements Internal.IHaveHoveringInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        startAnimation(box: Internal.ItemStack_, deposit: boolean): void;
        anticipate(): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        tryPullingFromOwnAndAdjacentInventories(): void;
        isAnimationInProgress(): boolean;
        tryPullingFrom(handler: Internal.Storage_<Internal.ItemVariant>): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        sendAnticipate(): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getYaw(): number;
        addToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get animationInProgress(): boolean
        get infiniteBoundingBox(): Internal.AABB
        get yaw(): number
        animatedPackage: Internal.ItemStack;
        anticipationProgress: Internal.LerpedFloat;
        currentlyDepositing: boolean;
        animationProgress: Internal.LerpedFloat;
        manualOpenAnimationProgress: Internal.LerpedFloat;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        passiveYaw: number;
        goggles: boolean;
        sendAnticipate: boolean;
    }
    type FrogportBlockEntity_ = FrogportBlockEntity;
    class BeltBlock extends Internal.HorizontalKineticBlock implements Internal.ProperWaterloggedBlock, Internal.BlockPickInteractionAware, Internal.ReducedDestroyEffects, Internal.MultiPosDestructionHandler, Internal.SpecialBlockItemRequirement, Internal.IBE<Internal.BeltBlockEntity>, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static canTransportObjects(state: Internal.BlockState_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static initBelt(world: Internal.Level_, pos: BlockPos_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, target: Internal.HitResult_): Internal.ItemStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.BeltBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.BeltBlockEntity>): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getBeltChain(world: Internal.LevelAccessor_, controllerPos: BlockPos_): Internal.List<BlockPos>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        static nextSegmentPosition(state: Internal.BlockState_, pos: BlockPos_, forward: boolean): BlockPos;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.BeltBlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.BeltBlockEntity>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        updateCoverProperty(world: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_): void;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getExtraPositions(level: Internal.ClientLevel_, pos: BlockPos_, blockState: Internal.BlockState_, progress: number): Internal.Set<BlockPos>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.BeltBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.BeltBlockEntity>;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isBlockCoveringBelt(world: Internal.LevelAccessor_, pos: BlockPos_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityType(): Internal.BlockEntityType<Internal.BeltBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityClass(): typeof Internal.BeltBlockEntity
        static readonly CASING: Internal.BooleanProperty;
        static readonly SLOPE: Internal.Property<Internal.BeltSlope>;
        static readonly PART: Internal.Property<Internal.BeltPart>;
    }
    type BeltBlock_ = BeltBlock;
    interface EnergyContainer extends earth.terrarium.botarium.util.Serializable, Internal.Clearable {
        tryClear($$0: any): void;
        getContainer(direction: Internal.Direction_): this;
        of(block: Internal.BlockEntity_, direction: Internal.Direction_): this;
        holdsEnergy(block: Internal.BlockEntity_, direction: Internal.Direction_): boolean;
        abstract allowsInsertion(): boolean;
        abstract getMaxCapacity(): number;
        abstract getStoredEnergy(): number;
        of(level: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): this;
        abstract createSnapshot(): Internal.EnergySnapshot;
        abstract allowsExtraction(): boolean;
        abstract serialize(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        abstract maxExtract(): number;
        abstract insertEnergy(arg0: number, arg1: boolean): number;
        holdsEnergy(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, entity: Internal.BlockEntity_, direction: Internal.Direction_): boolean;
        internalInsert(amount: number, simulate: boolean): number;
        abstract setEnergy(arg0: number): void;
        internalExtract(amount: number, simulate: boolean): number;
        readSnapshot(snapshot: Internal.EnergySnapshot_): void;
        of(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, entity: Internal.BlockEntity_, direction: Internal.Direction_): this;
        holdsEnergy(level: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        abstract extractEnergy(arg0: number, arg1: boolean): number;
        abstract maxInsert(): number;
        holdsEnergy(stack: Internal.ItemStack_): boolean;
        of(holder: Internal.ItemStackHolder_): this;
        abstract deserialize(arg0: Internal.CompoundTag_): void;
        abstract clearContent(): void;
        get maxCapacity(): number
        get storedEnergy(): number
        set energy(arg0: number)
    }
    type EnergyContainer_ = EnergyContainer;
    class TileExPatternProvider extends Internal.PatternProviderBlockEntity {
        constructor(pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getTerminalPatternInventory(): Internal.InternalInventory;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getConfigManager(): Internal.IConfigManager;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTerminalGroup(): Internal.PatternContainerGroup;
        getGrid(): Internal.IGrid;
        onLoad(): void;
        getTerminalSortOrder(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isVisibleInTerminal(): boolean;
        setPriority(newValue: number): void;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getPriority(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get terminalPatternInventory(): Internal.InternalInventory
        get configManager(): Internal.IConfigManager
        get terminalGroup(): Internal.PatternContainerGroup
        get grid(): Internal.IGrid
        get terminalSortOrder(): number
        get gridNode(): Internal.IGridNode
        get visibleInTerminal(): boolean
        set priority(newValue: number)
        get actionableNode(): Internal.IGridNode
        get priority(): number
        set owner(owner: Internal.Player_)
    }
    type TileExPatternProvider_ = TileExPatternProvider;
    interface IPocketUpgrade extends Internal.UpgradeBase {
        abstract createPeripheral(arg0: Internal.IPocketAccess_): Internal.IPeripheral;
        abstract getUpgradeID(): ResourceLocation;
        update(access: Internal.IPocketAccess_, peripheral: Internal.IPeripheral_): void;
        onRightClick(world: Internal.Level_, access: Internal.IPocketAccess_, peripheral: Internal.IPeripheral_): boolean;
        abstract getCraftingItem(): Internal.ItemStack;
        getUpgradeData(stack: Internal.ItemStack_): Internal.CompoundTag;
        getDefaultAdjective(id: ResourceLocation_): string;
        isItemSuitable(stack: Internal.ItemStack_): boolean;
        getUpgradeItem(upgradeData: Internal.CompoundTag_): Internal.ItemStack;
        abstract getUnlocalisedAdjective(): string;
        get upgradeID(): ResourceLocation
        get craftingItem(): Internal.ItemStack
        get unlocalisedAdjective(): string
    }
    type IPocketUpgrade_ = IPocketUpgrade;
    interface Bucketable {
        abstract saveToBucketTag(arg0: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        saveDefaultDataToBucketTag($$0: Internal.Mob_, $$1: Internal.ItemStack_): void;
        bucketMobPickup<T extends Internal.LivingEntity & Internal.Bucketable>($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: T): Internal.Optional<Internal.InteractionResult>;
        abstract loadFromBucketTag(arg0: Internal.CompoundTag_): void;
        /**
         * @deprecated
        */
        loadDefaultDataFromBucketTag($$0: Internal.Mob_, $$1: Internal.CompoundTag_): void;
        abstract getBucketItemStack(): Internal.ItemStack;
        abstract fromBucket(): boolean;
        abstract setFromBucket(arg0: boolean): void;
        abstract getPickupSound(): Internal.SoundEvent;
        get bucketItemStack(): Internal.ItemStack
        set fromBucket(arg0: boolean)
        get pickupSound(): Internal.SoundEvent
    }
    type Bucketable_ = Bucketable;
    class PloughBlock extends Internal.AttachedActorBlock {
        constructor(p_i48377_1_: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type PloughBlock_ = PloughBlock;
    class NetworkToolItem extends Internal.AEBaseItem implements Internal.IMenuItem, Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        static findNetworkToolInv(player: Internal.Player_): Internal.NetworkToolMenuHost;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getMenuHost(arg0: Internal.Player_, arg1: number, arg2: Internal.ItemStack_, arg3: BlockPos_): Internal.ItemMenuHost;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type NetworkToolItem_ = NetworkToolItem;
    interface BlockStateFlagHolder {
        abstract getAllFlags(): number;
        get allFlags(): number
        (): number;
    }
    type BlockStateFlagHolder_ = BlockStateFlagHolder;
    interface PoseStackExtensions {
        pushTransformation(transformation: Internal.Transformation_): void;
    }
    type PoseStackExtensions_ = PoseStackExtensions;
    abstract class DragonRoostStructure extends Internal.Structure {
    }
    type DragonRoostStructure_ = DragonRoostStructure;
    class WispjellyFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_, height: number): boolean;
        createSmallJelly(world: Internal.WorldGenLevel_, pos: BlockPos_): void;
        createLargeJelly(world: Internal.WorldGenLevel_, pos: BlockPos_): void;
        createTinyJelly(world: Internal.WorldGenLevel_, pos: BlockPos_): void;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type WispjellyFeature_ = WispjellyFeature;
    class FrogAttackablesSensor extends Internal.NearestVisibleLivingEntitySensor {
        constructor()
        static readonly TARGET_DETECTION_DISTANCE: 10.0;
    }
    type FrogAttackablesSensor_ = FrogAttackablesSensor;
    class PiggyBackPackItem extends Internal.TooltipItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        matchCarriedEntitiesToCount(player: Internal.LivingEntity_, maxCount: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PiggyBackPackItem_ = PiggyBackPackItem;
    interface DOMStringList {
        abstract item(arg0: number): string;
        abstract getLength(): number;
        abstract contains(arg0: string): boolean;
        get length(): number
    }
    type DOMStringList_ = DOMStringList;
    class FillingArrowWidget extends Internal.AnimatedTextureWidget {
        constructor(x: number, y: number, time: number)
        tooltipText(tooltip: Internal.List_<net.minecraft.network.chat.Component>): Internal.TextureWidget;
        tooltip(tooltip: Internal.List_<Internal.ClientTooltipComponent>): Internal.TextureWidget;
        tooltipText(tooltipSupplier: Internal.BiFunction_<number, number, Internal.List<net.minecraft.network.chat.Component>>): Internal.TextureWidget;
    }
    type FillingArrowWidget_ = FillingArrowWidget;
    class ItemBestiary extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemBestiary_ = ItemBestiary;
    interface DynamicOps <T> {
        abstract convertTo<U>(arg0: Internal.DynamicOps_<U>, arg1: T): U;
        abstract createNumeric(arg0: number): T;
        mergeToList(arg0: T, arg1: Internal.List_<T>): Internal.DataResult<T>;
        getMapEntries(arg0: T): Internal.DataResult<Internal.Consumer<Internal.BiConsumer<T, T>>>;
        abstract mergeToList(arg0: T, arg1: T): Internal.DataResult<T>;
        getByteBuffer(arg0: T): Internal.DataResult<Internal.ByteBuffer>;
        listBuilder(): Internal.ListBuilder<T>;
        convertMap<U>(arg0: Internal.DynamicOps_<U>, arg1: T): U;
        set(arg0: T, arg1: string, arg2: T): T;
        createInt(arg0: number): T;
        createFloat(arg0: number): T;
        createBoolean(arg0: boolean): T;
        getMap(arg0: T): Internal.DataResult<Internal.MapLike<T>>;
        withEncoder<E>(arg0: Internal.Encoder_<E>): Internal.Function<E, Internal.DataResult<T>>;
        updateGeneric(arg0: T, arg1: T, arg2: Internal.Function_<T, T>): T;
        createIntList(arg0: Internal.IntStream_): T;
        convertList<U>(arg0: Internal.DynamicOps_<U>, arg1: T): U;
        createShort(arg0: number): T;
        mapBuilder(): Internal.RecordBuilder<T>;
        update(arg0: T, arg1: string, arg2: Internal.Function_<T, T>): T;
        createMap(arg0: Internal.Map_<T, T>): T;
        abstract createString(arg0: string): T;
        getIntStream(arg0: T): Internal.DataResult<Internal.IntStream>;
        emptyList(): T;
        compressMaps(): boolean;
        getLongStream(arg0: T): Internal.DataResult<Internal.LongStream>;
        createLong(arg0: number): T;
        mergeToPrimitive(arg0: T, arg1: T): Internal.DataResult<T>;
        abstract empty(): T;
        abstract getStream(arg0: T): Internal.DataResult<Internal.Stream<T>>;
        abstract mergeToMap(arg0: T, arg1: T, arg2: T): Internal.DataResult<T>;
        createByteList(arg0: Internal.ByteBuffer_): T;
        abstract getNumberValue(arg0: T): Internal.DataResult<number>;
        withParser<E>(arg0: Internal.Decoder_<E>): Internal.Function<T, Internal.DataResult<E>>;
        emptyMap(): T;
        abstract createList(arg0: Internal.Stream_<T>): T;
        withDecoder<E>(arg0: Internal.Decoder_<E>): Internal.Function<T, Internal.DataResult<com.mojang.datafixers.util.Pair<E, T>>>;
        createByte(arg0: number): T;
        getGeneric(arg0: T, arg1: T): Internal.DataResult<T>;
        abstract createMap(arg0: Internal.Stream_<com.mojang.datafixers.util.Pair<T, T>>): T;
        getBooleanValue(arg0: T): Internal.DataResult<boolean>;
        createLongList(arg0: Internal.LongStream_): T;
        getNumberValue(arg0: T, arg1: number): number;
        createDouble(arg0: number): T;
        get(arg0: T, arg1: string): Internal.DataResult<T>;
        abstract getMapValues(arg0: T): Internal.DataResult<Internal.Stream<com.mojang.datafixers.util.Pair<T, T>>>;
        mergeToMap(arg0: T, arg1: Internal.Map_<T, T>): Internal.DataResult<T>;
        abstract getStringValue(arg0: T): Internal.DataResult<string>;
        getList(arg0: T): Internal.DataResult<Internal.Consumer<Internal.Consumer<T>>>;
        mergeToMap(arg0: T, arg1: Internal.MapLike_<T>): Internal.DataResult<T>;
        abstract remove(arg0: T, arg1: string): T;
    }
    type DynamicOps_<T> = DynamicOps<T>;
    class TatamiHalfMatBlock extends Internal.HorizontalDirectionalBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TatamiHalfMatBlock_ = TatamiHalfMatBlock;
    class VariantBlockStateBuilder$PartialBlockstate implements Internal.Predicate<Internal.BlockState> {
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        test(blockState: Internal.BlockState_): boolean;
        modelForState(): Internal.ConfiguredModel$Builder<Internal.VariantBlockStateBuilder>;
        getSetStates(): Internal.SortedMap<Internal.Property<any>, Internal.Comparable<any>>;
        static comparingByProperties(): Internal.Comparator<Internal.VariantBlockStateBuilder$PartialBlockstate>;
        addModels(...models: Internal.ConfiguredModel_[]): this;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        "with"<T extends Internal.Comparable<T>>(prop: Internal.Property_<T>, value: T): this;
        getOwner(): Internal.Block;
        test(arg0: any): boolean;
        and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        negate(): Internal.Predicate<Internal.BlockState>;
        partialState(): this;
        setModels(...models: Internal.ConfiguredModel_[]): Internal.VariantBlockStateBuilder;
        get setStates(): Internal.SortedMap<Internal.Property<any>, Internal.Comparable<any>>
        get owner(): Internal.Block
        set models(...models: Internal.ConfiguredModel_[])
    }
    type VariantBlockStateBuilder$PartialBlockstate_ = VariantBlockStateBuilder$PartialBlockstate;
    interface ExpandedMapData {
        abstract getVanillaDecorationSize(): number;
        abstract getCustomDecorations(): Internal.Map<string, Internal.CustomMapDecoration>;
        abstract getCustomData(): Internal.Map<ResourceLocation, Internal.CustomMapData<any>>;
        abstract copy(): Internal.MapItemSavedData;
        abstract getCustomMarkers(): Internal.Map<string, Internal.MapBlockMarker<any>>;
        abstract removeCustomMarker(arg0: string): boolean;
        abstract resetCustomDecoration(): void;
        abstract addCustomMarker<M extends Internal.MapBlockMarker<any>>(arg0: M): void;
        abstract toggleCustomDecoration(arg0: Internal.LevelAccessor_, arg1: BlockPos_): boolean;
        abstract setCustomDecorationsDirty(): void;
        abstract setCustomDataDirty<H extends Internal.CustomMapData$DirtyCounter>(arg0: Internal.CustomMapData$Type_<any>, arg1: Internal.Consumer_<H>): void;
        get vanillaDecorationSize(): number
        get customDecorations(): Internal.Map<string, Internal.CustomMapDecoration>
        get customData(): Internal.Map<ResourceLocation, Internal.CustomMapData<any>>
        get customMarkers(): Internal.Map<string, Internal.MapBlockMarker<any>>
    }
    type ExpandedMapData_ = ExpandedMapData;
    class ItemVaultBlockEntity extends Internal.SmartBlockEntity implements Internal.IMultiBlockEntityContainer$Inventory, Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        static getMaxLength(radius: number): number;
        removeController(keepContents: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getControllerBE(): Internal.BlockEntity;
        isController(): boolean;
        setController(controller: BlockPos_): void;
        setExtraData(data: any): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getLastKnownPos(): BlockPos;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        queueConnectivityUpdate(): void;
        preventConnectivityUpdate(): void;
        notifyMultiUpdated(): void;
        getExtraData(): any;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getInvId(): Internal.InventoryIdentifier;
        applyInventoryToBlock(handler: io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler_): void;
        setWidth(width: number): void;
        getHeight(): number;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getMaxLength(longAxis: Internal.Direction$Axis_, width: number): number;
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMaxWidth(): number;
        invalidateCaps(): void;
        getWidth(): number;
        hasInventory(): boolean;
        modifyExtraData(data: any): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getController(): BlockPos;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getMainConnectionAxis(): Internal.Direction$Axis;
        getInventoryOfBlock(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        setHeight(height: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get controllerBE(): Internal.BlockEntity
        get controller(): boolean
        set controller(controller: BlockPos_)
        set extraData(data: any)
        get lastKnownPos(): BlockPos
        get extraData(): any
        get invId(): Internal.InventoryIdentifier
        set width(width: number)
        get height(): number
        get maxWidth(): number
        get width(): number
        get controller(): BlockPos
        get infiniteBoundingBox(): Internal.AABB
        get mainConnectionAxis(): Internal.Direction$Axis
        get inventoryOfBlock(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler
        set height(height: number)
    }
    type ItemVaultBlockEntity_ = ItemVaultBlockEntity;
    interface ProjectileSlotHolder {
        abstract arsenal$getOwnedSlot(): number;
        abstract arsenal$setOwnedSlot(arg0: number): void;
    }
    type ProjectileSlotHolder_ = ProjectileSlotHolder;
    class AllArmInteractionPointTypes$BeltType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$BeltType_ = AllArmInteractionPointTypes$BeltType;
    abstract class Struct extends Internal.Pointer$Default {
        static validate(arg0: number, arg1: number, arg2: number, arg3: Internal.Struct$StructValidation_): void;
        free(): void;
        clear(): void;
        isNull(arg0: number): boolean;
        abstract sizeof(): number;
    }
    type Struct_ = Struct;
    class SmithingMenu extends Internal.ItemCombinerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: any_)
        constructor($$0: number, $$1: Internal.Inventory_)
        method_48356($$0: Internal.ItemStack_): boolean;
        static readonly BASE_SLOT: 1;
        static readonly TEMPLATE_SLOT: 0;
        static readonly RESULT_SLOT: 3;
        static readonly ADDITIONAL_SLOT_X_PLACEMENT: 44;
        static readonly TEMPLATE_SLOT_X_PLACEMENT: 8;
        static readonly BASE_SLOT_X_PLACEMENT: 26;
        selectedRecipe: Internal.SmithingRecipe;
        static readonly SLOT_Y_PLACEMENT: 48;
        static readonly ADDITIONAL_SLOT: 2;
    }
    type SmithingMenu_ = SmithingMenu;
    class BasicBlockJS$Builder extends Internal.BlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): Internal.Block;
    }
    type BasicBlockJS$Builder_ = BasicBlockJS$Builder;
    abstract class ScheduleDataEntry implements Internal.IScheduleInput {
        constructor()
        setData(data: Internal.CompoundTag_): void;
        abstract getId(): ResourceLocation;
        getItem(slot: number): Internal.ItemStack;
        slotsTargeted(): number;
        getData(): Internal.CompoundTag;
        getSecondLineTooltip(slot: number): Internal.List<net.minecraft.network.chat.Component>;
        setItem(slot: number, stack: Internal.ItemStack_): void;
        abstract getSummary(): net.createmod.catnip.data.Pair<Internal.ItemStack, net.minecraft.network.chat.Component>;
        getSecondLineIcon(): Internal.ItemStack;
        getTitleAs(type: string): Internal.List<net.minecraft.network.chat.Component>;
        renderSpecialIcon(graphics: Internal.GuiGraphics_, x: number, y: number): boolean;
        initConfigurationWidgets(builder: Internal.ModularGuiLineBuilder_): void;
        set data(data: Internal.CompoundTag_)
        get id(): ResourceLocation
        get data(): Internal.CompoundTag
        get summary(): net.createmod.catnip.data.Pair<Internal.ItemStack, net.minecraft.network.chat.Component>
        get secondLineIcon(): Internal.ItemStack
    }
    type ScheduleDataEntry_ = ScheduleDataEntry;
    class TileExCharger extends Internal.AENetworkPowerBlockEntity implements Internal.IGridTickable {
        constructor(pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        isWorking(): boolean;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getTickingRequest(node: Internal.IGridNode_): Internal.TickingRequest;
        activate(player: Internal.Player_): void;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getCrankable(direction: Internal.Direction_): Internal.ICrankable;
        getPriority(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        tickingRequest(node: Internal.IGridNode_, ticksSinceLastCall: number): Internal.TickRateModulation;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get working(): boolean
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        get priority(): number
        set owner(owner: Internal.Player_)
        static readonly MAX_THREAD: 4;
        static readonly POWER_MAXIMUM_AMOUNT: 3200;
    }
    type TileExCharger_ = TileExCharger;
    class CommandBlockEntity$Mode extends Internal.Enum<Internal.CommandBlockEntity$Mode> {
        static values(): Internal.CommandBlockEntity$Mode[];
        static valueOf($$0: string): Internal.CommandBlockEntity$Mode;
        static readonly AUTO: Internal.CommandBlockEntity$Mode;
        static readonly REDSTONE: Internal.CommandBlockEntity$Mode;
        static readonly SEQUENCE: Internal.CommandBlockEntity$Mode;
    }
    type CommandBlockEntity$Mode_ = "sequence" | "auto" | "redstone" | CommandBlockEntity$Mode;
    class UUID implements Internal.Comparable<Internal.UUID>, Internal.Serializable {
        constructor(arg0: number, arg1: number)
        clockSequence(): number;
        static randomUUID(): Internal.UUID;
        version(): number;
        compareTo(arg0: Internal.UUID_): number;
        static nameUUIDFromBytes(arg0: number[]): Internal.UUID;
        node(): number;
        timestamp(): number;
        variant(): number;
        getMostSignificantBits(): number;
        compareTo(arg0: any): number;
        static fromString(arg0: string): Internal.UUID;
        getLeastSignificantBits(): number;
        get mostSignificantBits(): number
        get leastSignificantBits(): number
    }
    type UUID_ = UUID;
    interface IPackRepository {
        abstract voicechat$addSource(arg0: Internal.RepositorySource_): void;
        (arg0: Internal.RepositorySource): void;
    }
    type IPackRepository_ = IPackRepository;
    interface Double2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleToLongFunction {
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Double2FloatFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2LongFunction<T>;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Double2IntFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Double2CharFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        getOrDefault(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2LongFunction<T>;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2LongFunction;
        apply(arg0: number): number;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Double2ByteFunction;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2LongFunction;
        abstract get(arg0: number): number;
        defaultReturnValue(): number;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2LongFunction;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Double2DoubleFunction;
        applyAsLong(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Double2ShortFunction;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        containsKey(arg0: number): boolean;
        size(): number;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2LongFunction;
        clear(): void;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2LongFunction;
        identity<T>(): Internal.Function<T, T>;
        put(arg0: number, arg1: number): number;
        defaultReturnValue(arg0: number): void;
        (arg0: number): number;
    }
    type Double2LongFunction_ = Double2LongFunction;
    abstract class DynamicConstantDesc <T> implements Internal.ConstantDesc {
        bootstrapMethod(): Internal.DirectMethodHandleDesc;
        constantName(): string;
        bootstrapArgs(): Internal.ConstantDesc[];
        constantType(): Internal.ClassDesc;
        static of<T>(arg0: Internal.DirectMethodHandleDesc_): Internal.DynamicConstantDesc<T>;
        static ofNamed<T>(arg0: Internal.DirectMethodHandleDesc_, arg1: string, arg2: Internal.ClassDesc_, ...arg3: Internal.ConstantDesc_[]): Internal.DynamicConstantDesc<T>;
        bootstrapArgsList(): Internal.List<Internal.ConstantDesc>;
        resolveConstantDesc(arg0: Internal.MethodHandles$Lookup_): T;
        static ofCanonical<T>(arg0: Internal.DirectMethodHandleDesc_, arg1: string, arg2: Internal.ClassDesc_, arg3: Internal.ConstantDesc_[]): Internal.ConstantDesc;
        static of<T>(arg0: Internal.DirectMethodHandleDesc_, ...arg1: Internal.ConstantDesc_[]): Internal.DynamicConstantDesc<T>;
    }
    type DynamicConstantDesc_<T> = DynamicConstantDesc<T>;
    class ScheduleRuntime$State extends Internal.Enum<Internal.ScheduleRuntime$State> {
        static valueOf(name: string): Internal.ScheduleRuntime$State;
        static values(): Internal.ScheduleRuntime$State[];
        static readonly POST_TRANSIT: Internal.ScheduleRuntime$State;
        static readonly IN_TRANSIT: Internal.ScheduleRuntime$State;
        static readonly PRE_TRANSIT: Internal.ScheduleRuntime$State;
    }
    type ScheduleRuntime$State_ = "pre_transit" | "post_transit" | ScheduleRuntime$State | "in_transit";
    class HexRecipeStuffRegistry$1 implements Internal.RecipeType<T> {
        static register<T extends Internal.Recipe<any>>($$0: string): Internal.RecipeType<T>;
    }
    type HexRecipeStuffRegistry$1_ = HexRecipeStuffRegistry$1;
    interface IWrenchable {
        abstract onWrench(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.Direction_, arg6: Internal.WrenchMode_, arg7: Vec3d_): boolean;
        (arg0: Internal.BlockState, arg1: Internal.Level, arg2: BlockPos, arg3: Internal.Player, arg4: Internal.InteractionHand, arg5: Internal.Direction, arg6: Internal.WrenchMode, arg7: Vec3d): boolean;
    }
    type IWrenchable_ = IWrenchable;
    class ResourceArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.ResourceArgument<T>> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        type(): Internal.ArgumentTypeInfo<Internal.ResourceArgument<T>, any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.ResourceArgument<T>;
    }
    type ResourceArgument$Info$Template_ = ResourceArgument$Info$Template;
    abstract class Maps$IteratorBasedAbstractMap <K, V> extends Internal.AbstractMap<K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type Maps$IteratorBasedAbstractMap_<K, V> = Maps$IteratorBasedAbstractMap<K, V>;
    interface AccessorToolboxInventory {
        abstract getFilters(): Internal.List<Internal.ItemStack>;
        get filters(): Internal.List<Internal.ItemStack>
        (): Internal.List_<Internal.ItemStack>;
    }
    type AccessorToolboxInventory_ = AccessorToolboxInventory;
    class EntropyMode extends Internal.Enum<Internal.EntropyMode> {
        static valueOf(name: string): Internal.EntropyMode;
        static values(): Internal.EntropyMode[];
        static readonly HEAT: Internal.EntropyMode;
        static readonly COOL: Internal.EntropyMode;
    }
    type EntropyMode_ = "cool" | "heat" | EntropyMode;
    class EmptyPoolElement extends Internal.StructurePoolElement {
        static readonly CODEC: Internal.Codec<Internal.EmptyPoolElement>;
        static readonly INSTANCE: Internal.EmptyPoolElement;
    }
    type EmptyPoolElement_ = EmptyPoolElement;
    class SimpleCraftingRecipeSerializer <T extends Internal.CraftingRecipe> implements Internal.RecipeSerializer<T> {
        constructor($$0: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): T;
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SimpleCraftingRecipeSerializer_<T extends Internal.CraftingRecipe> = SimpleCraftingRecipeSerializer<T>;
    class SemaphoreDisplayTarget extends Internal.DisplayTarget {
        constructor()
    }
    type SemaphoreDisplayTarget_ = SemaphoreDisplayTarget;
    class StressGaugeBlockEntity extends Internal.GaugeBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getNetworkStress(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getNetworkCapacity(): number;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        onObserved(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get networkStress(): number
        get networkCapacity(): number
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type StressGaugeBlockEntity_ = StressGaugeBlockEntity;
    class MysteriousCubeBlock extends Internal.AEBaseBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly PROPERTIES: Internal.BlockBehaviour$Properties;
    }
    type MysteriousCubeBlock_ = MysteriousCubeBlock;
    interface ItemAttribute {
        format(inverted: boolean): Internal.MutableComponent;
        loadStatic(nbt: Internal.CompoundTag_): this;
        abstract load(arg0: Internal.CompoundTag_): void;
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        abstract getTranslationKey(): string;
        saveStatic(attribute: Internal.ItemAttribute_): Internal.CompoundTag;
        abstract save(arg0: Internal.CompoundTag_): void;
        abstract getType(): Internal.ItemAttributeType;
        abstract appliesTo(arg0: Internal.ItemStack_, arg1: Internal.Level_): boolean;
        getTranslationParameters(): any[];
        get translationKey(): string
        get type(): Internal.ItemAttributeType
        get translationParameters(): any[]
    }
    type ItemAttribute_ = ItemAttribute;
    class BlockStateProviderType <P extends Internal.BlockStateProvider> {
        constructor($$0: Internal.Codec_<P>)
        codec(): Internal.Codec<P>;
        static readonly WEIGHTED_STATE_PROVIDER: Internal.BlockStateProviderType<Internal.WeightedStateProvider>;
        static readonly SIMPLE_STATE_PROVIDER: Internal.BlockStateProviderType<Internal.SimpleStateProvider>;
        static readonly DUAL_NOISE_PROVIDER: Internal.BlockStateProviderType<Internal.DualNoiseProvider>;
        static readonly NOISE_THRESHOLD_PROVIDER: Internal.BlockStateProviderType<Internal.NoiseThresholdProvider>;
        static readonly ROTATED_BLOCK_PROVIDER: Internal.BlockStateProviderType<Internal.RotatedBlockProvider>;
        static readonly NOISE_PROVIDER: Internal.BlockStateProviderType<Internal.NoiseProvider>;
        static readonly RANDOMIZED_INT_STATE_PROVIDER: Internal.BlockStateProviderType<Internal.RandomizedIntStateProvider>;
    }
    type BlockStateProviderType_<P extends Internal.BlockStateProvider> = Special.BlockStateProviderType | BlockStateProviderType<P>;
    class PulleyBlock$MagnetBlock extends Internal.PulleyBlock$RopeBlockBase {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type PulleyBlock$MagnetBlock_ = PulleyBlock$MagnetBlock;
    interface ServerWorldCache {
        abstract fabric_registerCache(arg0: BlockPos_, arg1: Internal.BlockApiCacheImpl_<any, any>): void;
        abstract fabric_invalidateCache(arg0: BlockPos_): void;
    }
    type ServerWorldCache_ = ServerWorldCache;
    class ItemFocus extends Internal.Item implements Internal.VariantItem, Internal.IotaHolderItem {
        constructor(pProperties: Internal.Item$Properties_)
        canWrite(stack: Internal.ItemStack_, datum: Internal.Iota_): boolean;
        writeable(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        writeDatum(stack: Internal.ItemStack_, datum: Internal.Iota_): void;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emptyIota(stack: Internal.ItemStack_): Internal.Iota;
        numVariants(): number;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getColor(stack: Internal.ItemStack_): number;
        getVariant(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        readIotaTag(stack: Internal.ItemStack_): Internal.CompoundTag;
        static appendHoverText(self: Internal.IotaHolderItem_, stack: Internal.ItemStack_, components: Internal.List_<net.minecraft.network.chat.Component>, flag: Internal.TooltipFlag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        readIota(stack: Internal.ItemStack_, world: Internal.ServerLevel_): Internal.Iota;
        static seal(stack: Internal.ItemStack_): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setVariant(stack: Internal.ItemStack_, variant: number): void;
        static isSealed(stack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        clampVariant(variant: number): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static readonly TAG_SEALED: "sealed";
        static readonly VARIANT_PRED: ResourceLocation;
        static readonly TAG_DATA: "data";
        static readonly OVERLAY_PRED: ResourceLocation;
        static readonly NUM_VARIANTS: 8;
    }
    type ItemFocus_ = ItemFocus;
    interface Thread$Builder {
        abstract inheritInheritableThreadLocals(arg0: boolean): this;
        abstract start(arg0: Internal.Runnable_): Internal.Thread;
        abstract name(arg0: string, arg1: number): this;
        abstract factory(): Internal.ThreadFactory;
        abstract name(arg0: string): this;
        abstract uncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_): this;
        abstract unstarted(arg0: Internal.Runnable_): Internal.Thread;
    }
    type Thread$Builder_ = Thread$Builder;
    abstract class AbstractProperty <T extends Internal.AbstractDocumentBase<T>> extends Internal.AbstractDocumentBase<T> {
        constructor()
        applyProperties(): T;
    }
    type AbstractProperty_<T extends Internal.AbstractDocumentBase<T>> = AbstractProperty<T>;
    abstract class ForwardingCollection <E> extends Internal.ForwardingObject implements Internal.Collection<E> {
        add(arg0: E): boolean;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        remove(arg0: any): boolean;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        toArray(): any[];
        iterator(): Internal.Iterator<E>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        size(): number;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        contains(arg0: any): boolean;
        addAll(arg0: Internal.Collection_<E>): boolean;
        get empty(): boolean
    }
    type ForwardingCollection_<E> = ForwardingCollection<E>;
    interface SlimeExtension {
        spawnCustomParticles(): boolean;
    }
    type SlimeExtension_ = SlimeExtension;
    class SequencedGearshiftBlockEntity extends Internal.SplitShaftBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getModifier(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isIdle(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getInstruction(instructionIndex: number): Internal.Instruction;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getInstructions(): Internal.Vector<Internal.Instruction>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        onRedstoneUpdate(isPowered: boolean, isRunning: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        run(instructionIndex: number): void;
        risingFlank(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get modifier(): number
        get idle(): boolean
        get instructions(): Internal.Vector<Internal.Instruction>
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type SequencedGearshiftBlockEntity_ = SequencedGearshiftBlockEntity;
    class SaplingBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor($$0: any_, $$1: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        advanceTree($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.RandomSource_): void;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STAGE: Internal.IntegerProperty;
    }
    type SaplingBlock_ = SaplingBlock;
    interface EntityEvents$EntitySize {
        abstract onEntitySizeChange(arg0: Internal.EntityEvents$Size_): void;
        (arg0: Internal.EntityEvents$Size): void;
    }
    type EntityEvents$EntitySize_ = EntityEvents$EntitySize;
    class Subject implements Internal.Serializable {
        constructor()
        constructor(arg0: boolean, arg1: Internal.Set_<Internal.Principal>, arg2: Internal.Set_<any>, arg3: Internal.Set_<any>)
        getPrivateCredentials<T>(arg0: T): Internal.Set<T>;
        getPublicCredentials<T>(arg0: T): Internal.Set<T>;
        static callAs<T>(arg0: Internal.Subject_, arg1: Internal.Callable_<T>): T;
        getPublicCredentials(): Internal.Set<any>;
        getPrivateCredentials(): Internal.Set<any>;
        getPrincipals<T extends Internal.Principal>(arg0: T): Internal.Set<T>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        static doAs<T>(arg0: Internal.Subject_, arg1: Internal.PrivilegedExceptionAction_<T>): T;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        static getSubject(arg0: Internal.AccessControlContext_): Internal.Subject;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        static doAsPrivileged<T>(arg0: Internal.Subject_, arg1: Internal.PrivilegedAction_<T>, arg2: Internal.AccessControlContext_): T;
        setReadOnly(): void;
        static current(): Internal.Subject;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        static doAs<T>(arg0: Internal.Subject_, arg1: Internal.PrivilegedAction_<T>): T;
        isReadOnly(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        static doAsPrivileged<T>(arg0: Internal.Subject_, arg1: Internal.PrivilegedExceptionAction_<T>, arg2: Internal.AccessControlContext_): T;
        getPrincipals(): Internal.Set<Internal.Principal>;
        get publicCredentials(): Internal.Set<any>
        get privateCredentials(): Internal.Set<any>
        get readOnly(): boolean
        get principals(): Internal.Set<Internal.Principal>
    }
    type Subject_ = Subject;
    class WorldSessionTelemetryManager {
        constructor($$0: Internal.TelemetryEventSender_, $$1: boolean, $$2: Duration_, $$3: string)
        onPlayerInfoReceived($$0: Internal.GameType_, $$1: boolean): void;
        onServerBrandReceived($$0: string): void;
        worldSessionStart(): void;
        onAdvancementDone($$0: Internal.Level_, $$1: Internal.Advancement_): void;
        tick(): void;
        onDisconnect(): void;
        setTime($$0: number): void;
        set time($$0: number)
    }
    type WorldSessionTelemetryManager_ = WorldSessionTelemetryManager;
    interface IBlockClickResponseUpgrade {
        abstract onBlockClick(arg0: Internal.Player_, arg1: BlockPos_): boolean;
        (arg0: Internal.Player, arg1: BlockPos): boolean;
    }
    type IBlockClickResponseUpgrade_ = IBlockClickResponseUpgrade;
    class CommandBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        markConditionMet(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setAutomatic($$0: boolean): void;
        onLoad(): void;
        getMode(): Internal.CommandBlockEntity$Mode;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        onModeSwitch(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        isPowered(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        isAutomatic(): boolean;
        getCommandBlock(): Internal.BaseCommandBlock;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        wasConditionMet(): boolean;
        isConditional(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setPowered($$0: boolean): void;
        set automatic($$0: boolean)
        get mode(): Internal.CommandBlockEntity$Mode
        get powered(): boolean
        get automatic(): boolean
        get commandBlock(): Internal.BaseCommandBlock
        get conditional(): boolean
        set powered($$0: boolean)
    }
    type CommandBlockEntity_ = CommandBlockEntity;
    class RecordItemJS$Builder extends Internal.ItemBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Sets the redstone output of the jukebox when this record is played.
        */
        analogOutput(o: number): this;
        song(song: Internal.SoundEvent_): this;
        createObject(): any;
        /**
         * Sets the song that will play when this record is played.
         * @param s The location of sound event.
         * @param seconds The length of the song in seconds.
        */
        song(s: ResourceLocation_, seconds: number): this;
        getSoundEvent(): Internal.SoundEvent;
        get soundEvent(): Internal.SoundEvent
    }
    type RecordItemJS$Builder_ = RecordItemJS$Builder;
    class WoodenPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type WoodenPipeBlock_ = WoodenPipeBlock;
    class MoltenMetalBlock extends Internal.LiquidBlock {
        constructor(flowingFluid: Internal.FlowingFluid_, properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static callInit(fluid: Internal.FlowingFluid_, settings: Internal.BlockBehaviour$Properties_): Internal.LiquidBlock;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        arch$getFluid(): Internal.FlowingFluid;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MoltenMetalBlock_ = MoltenMetalBlock;
    abstract class SingleBlockEntityEdgePoint extends Internal.TrackEdgePoint {
        constructor()
        getBlockEntityPos(): BlockPos;
        getBlockEntityDimension(): Internal.ResourceKey<Internal.Level>;
        get blockEntityPos(): BlockPos
        get blockEntityDimension(): Internal.ResourceKey<Internal.Level>
        blockEntityPos: BlockPos;
        blockEntityDimension: Internal.ResourceKey<Internal.Level>;
    }
    type SingleBlockEntityEdgePoint_ = SingleBlockEntityEdgePoint;
    abstract class SpellcasterIllager extends Internal.AbstractIllager {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        setIsCastingSpell($$0: Internal.SpellcasterIllager$IllagerSpell_): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        isCastingSpell(): boolean;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set isCastingSpell($$0: Internal.SpellcasterIllager$IllagerSpell_)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get castingSpell(): boolean
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type SpellcasterIllager_ = SpellcasterIllager;
    class StatsCounter {
        constructor()
        getValue($$0: Internal.Stat_<any>): number;
        increment($$0: Internal.Player_, $$1: Internal.Stat_<any>, $$2: number): void;
        getValue<T>($$0: Internal.StatType_<T>, $$1: T): number;
        setValue($$0: Internal.Player_, $$1: Internal.Stat_<any>, $$2: number): void;
    }
    type StatsCounter_ = StatsCounter;
    class RegistrateTagsProvider$IntrinsicImpl <T> extends Internal.FabricTagProvider<T> implements Internal.RegistrateTagsProvider<T> {
        constructor(owner: Internal.AbstractRegistrate_<any>, type: Internal.ProviderType_<Internal.RegistrateTagsProvider$IntrinsicImpl<T>>, name: string, packOutput: Internal.FabricDataOutput_, registryIn: Internal.ResourceKey_<Internal.Registry<T>>, registriesLookup: Internal.CompletableFuture_<Internal.HolderLookup$Provider>, keyExtractor: Internal.Function_<T, Internal.ResourceKey<T>>)
        addTag(tag: Internal.TagKey_<T>): Internal.FabricTagProvider$FabricTagBuilder<>;
        getSide(): Internal.EnvType;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get side(): Internal.EnvType
    }
    type RegistrateTagsProvider$IntrinsicImpl_<T> = RegistrateTagsProvider$IntrinsicImpl<T>;
    class TileCaner extends Internal.AENetworkPowerBlockEntity implements Internal.IGridTickable, Internal.ICraftingMachine {
        constructor(pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        getMode(): Internal.CanerMode;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setMode(mode: Internal.CanerMode_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getContainer(): Internal.AppEngInternalInventory;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        acceptsPlans(): boolean;
        onLoad(): void;
        getStuff(): Internal.GenericStackInv;
        static of(blockEntity: Internal.BlockEntity_, side: Internal.Direction_): Internal.ICraftingMachine;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getTickingRequest(node: Internal.IGridNode_): Internal.TickingRequest;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        static of(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_, blockEntity: Internal.BlockEntity_): Internal.ICraftingMachine;
        isDone(): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getCraftingMachineInfo(): Internal.PatternContainerGroup;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getPriority(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        tickingRequest(node: Internal.IGridNode_, ticksSinceLastCall: number): Internal.TickRateModulation;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        pushPattern(patternDetails: Internal.IPatternDetails_, inputs: Internal.KeyCounter_[], ejectionDirection: Internal.Direction_): boolean;
        get displayName(): net.minecraft.network.chat.Component
        get mode(): Internal.CanerMode
        set mode(mode: Internal.CanerMode_)
        get container(): Internal.AppEngInternalInventory
        get stuff(): Internal.GenericStackInv
        get gridNode(): Internal.IGridNode
        get done(): boolean
        get craftingMachineInfo(): Internal.PatternContainerGroup
        get actionableNode(): Internal.IGridNode
        get priority(): number
        set owner(owner: Internal.Player_)
        static readonly POWER_USAGE: 80;
        static readonly POWER_MAXIMUM_AMOUNT: 3200;
    }
    type TileCaner_ = TileCaner;
    interface DataProvider {
        abstract run(arg0: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        abstract getName(): string;
        saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get name(): string
        readonly FIXED_ORDER_FIELDS: {"fabric:type": 0, "parent": 1, "fabric:load_conditions": -100, "type": 0};
        readonly KEY_COMPARATOR: Internal.Comparator<string>;
        readonly LOGGER: Internal.Log4jLogger;
    }
    type DataProvider_ = DataProvider;
    class Slime extends Internal.Mob implements Internal.Enemy, Internal.SlimeExtension {
        constructor($$0: Internal.EntityType_<Internal.Slime>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getSize(): number;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        setSize($$0: number, $$1: boolean): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        spawnCustomParticles(): boolean;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static checkSlimeSpawnRules($$0: Internal.EntityType_<Internal.Slime>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        isTiny(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        getEntityType(): Internal.EntityType<Internal.Slime>;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get size(): number
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get tiny(): boolean
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get entityType(): Internal.EntityType<Internal.Slime>
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly MIN_SIZE: 1;
        targetSquish: number;
        squish: number;
        static readonly MAX_SIZE: 127;
        oSquish: number;
    }
    type Slime_ = Slime;
    class EnergyHopperBlock extends Internal.AbstractEnergyBlock<Internal.ChargingConfig, Internal.EnergyHopperBlock> {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getConfig(): Internal.ChargingConfig;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get config(): Internal.ChargingConfig
    }
    type EnergyHopperBlock_ = EnergyHopperBlock;
    class TippedArrowRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type TippedArrowRecipe_ = TippedArrowRecipe;
    interface DripstoneInteractingFluid {
        abstract fillsCauldrons(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        abstract getFluidDripChance(arg0: Internal.Level_, arg1: Internal.PointedDripstoneBlock$FluidInfo_): number;
        abstract growsDripstone(arg0: Internal.BlockState_): boolean;
        abstract getCauldronBlockState(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.BlockState;
        abstract getParticleColor(arg0: Internal.Level_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): number;
        getFluidDripWorldEvent(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): number;
        readonly LAVA_DRIP_CHANCE: 0.05859375;
        readonly WATER_DRIP_CHANCE: 0.17578125;
    }
    type DripstoneInteractingFluid_ = DripstoneInteractingFluid;
    abstract class MilkFluid extends Internal.FlowingFluid implements Internal.DripstoneInteractingFluid {
        constructor()
        fillsCauldrons(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): boolean;
        getFluidDripChance(world: Internal.Level_, drippingFluid: Internal.PointedDripstoneBlock$FluidInfo_): number;
        growsDripstone(state: Internal.BlockState_): boolean;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getCauldronBlockState(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): Internal.BlockState;
        getParticleColor(world: Internal.Level_, x: number, y: number, z: number, velocityX: number, velocityY: number, velocityZ: number): number;
        getFluidDripWorldEvent(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): number;
        arch$registryName(): ResourceLocation;
    }
    type MilkFluid_ = MilkFluid;
    class StonecuttingPatternItem extends Internal.EncodedPatternItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        encode(recipe: Internal.StonecutterRecipe_, in_: Internal.AEItemKey_, out: Internal.AEItemKey_, allowSubstitutes: boolean): Internal.ItemStack;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type StonecuttingPatternItem_ = StonecuttingPatternItem;
    interface FluidSnapshot {
        abstract loadSnapshot(arg0: Internal.FluidContainer_): void;
        (arg0: Internal.FluidContainer): void;
    }
    type FluidSnapshot_ = FluidSnapshot;
    interface Comparison$HashFunction {
        abstract hash(arg0: Internal.EmiStack_): number;
        (arg0: Internal.EmiStack): number;
    }
    type Comparison$HashFunction_ = Comparison$HashFunction;
    interface OptionInstance$CaptionBasedToString <T> {
        abstract toString(arg0: net.minecraft.network.chat.Component_, arg1: T): net.minecraft.network.chat.Component;
        (arg0: net.minecraft.network.chat.Component, arg1: T): net.minecraft.network.chat.Component_;
    }
    type OptionInstance$CaptionBasedToString_<T> = OptionInstance$CaptionBasedToString<T>;
    interface ICellWorkbenchItem extends Internal.IUpgradeableItem {
        getUpgrades(stack: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        isEditable(is: Internal.ItemStack_): boolean;
        abstract asItem(): Internal.Item;
        emi(): Internal.EmiStack;
        abstract setFuzzyMode(arg0: Internal.ItemStack_, arg1: Internal.FuzzyMode_): void;
        abstract getFuzzyMode(arg0: Internal.ItemStack_): Internal.FuzzyMode;
    }
    type ICellWorkbenchItem_ = ICellWorkbenchItem;
    class InterfaceLogic implements Internal.IUpgradeableObject, Internal.IConfigurableObject, Internal.ICraftingRequester {
        constructor(gridNode: Internal.IManagedGridNode_, host: Internal.InterfaceLogicHost_, is: Internal.Item_)
        constructor(gridNode: Internal.IManagedGridNode_, host: Internal.InterfaceLogicHost_, is: Internal.Item_, slots: number)
        notifyNeighbors(): void;
        insertCraftedItems(link: Internal.ICraftingLink_, what: Internal.AEKey_, amount: number, mode: Internal.Actionable_): number;
        getCableConnectionType(dir: Internal.Direction_): Internal.AECableType;
        readFromNBT(tag: Internal.CompoundTag_): void;
        getStorage(): Internal.ConfigInventory;
        getConfig(): Internal.ConfigInventory;
        gridChanged(): void;
        addDrops(drops: Internal.List_<Internal.ItemStack>): void;
        getConfigManager(): Internal.IConfigManager;
        writeToNBT(tag: Internal.CompoundTag_): void;
        getInventory(): Internal.MEStorage;
        jobStateChange(link: Internal.ICraftingLink_): void;
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        setPriority(priority: number): void;
        getActionableNode(): Internal.IGridNode;
        getPriority(): number;
        getLocation(): Internal.DimensionalBlockPos;
        getUpgrades(): Internal.IUpgradeInventory;
        getRequestedJobs(): Internal.ImmutableSet<Internal.ICraftingLink>;
        clearContent(): void;
        get storage(): Internal.ConfigInventory
        get config(): Internal.ConfigInventory
        get configManager(): Internal.IConfigManager
        get inventory(): Internal.MEStorage
        set priority(priority: number)
        get actionableNode(): Internal.IGridNode
        get priority(): number
        get location(): Internal.DimensionalBlockPos
        get upgrades(): Internal.IUpgradeInventory
        get requestedJobs(): Internal.ImmutableSet<Internal.ICraftingLink>
    }
    type InterfaceLogic_ = InterfaceLogic;
    class TrapezoidFloat extends Internal.FloatProvider {
        static of($$0: number, $$1: number, $$2: number): Internal.TrapezoidFloat;
        static readonly CODEC: Internal.Codec<Internal.TrapezoidFloat>;
    }
    type TrapezoidFloat_ = TrapezoidFloat;
    class SlotType {
        getDisplayName(): net.minecraft.network.chat.Component;
        getPrefix(): string;
        write(buffer: Internal.FriendlyByteBuf_): void;
        static init(): void;
        static isValidName(name: string): boolean;
        static read(tag: Internal.CompoundTag_): Internal.SlotType;
        static getOrCreate(name: string): Internal.SlotType;
        write(tag: Internal.CompoundTag_): void;
        getColor(): Internal.TextColor;
        static getAllSlotTypes(): Internal.Collection<Internal.SlotType>;
        getName(): string;
        static getIfPresent(name: string): Internal.SlotType;
        static create(name: string, color: number): Internal.SlotType;
        static read(buffer: Internal.FriendlyByteBuf_): Internal.SlotType;
        get displayName(): net.minecraft.network.chat.Component
        get prefix(): string
        get color(): Internal.TextColor
        get allSlotTypes(): Internal.Collection<Internal.SlotType>
        get name(): string
        static readonly DEFENSE: Internal.SlotType;
        static readonly UPGRADE: Internal.SlotType;
        static readonly SOUL: Internal.SlotType;
        static readonly ABILITY: Internal.SlotType;
    }
    type SlotType_ = SlotType;
    abstract class EnchantmentCategory extends Internal.Enum<Internal.EnchantmentCategory> {
        static valueOf($$0: string): Internal.EnchantmentCategory;
        abstract canEnchant(arg0: Internal.Item_): boolean;
        static values(): Internal.EnchantmentCategory[];
        static readonly ARMOR_CHEST: Internal.EnchantmentCategory;
        static readonly BOW: Internal.EnchantmentCategory;
        static readonly ARMOR: Internal.EnchantmentCategory;
        static readonly ARMOR_FEET: Internal.EnchantmentCategory;
        static readonly TRIDENT: Internal.EnchantmentCategory;
        static readonly CROSSBOW: Internal.EnchantmentCategory;
        static readonly BREAKABLE: Internal.EnchantmentCategory;
        static readonly WEAPON: Internal.EnchantmentCategory;
        static readonly ARMOR_HEAD: Internal.EnchantmentCategory;
        static readonly ARMOR_LEGS: Internal.EnchantmentCategory;
        static readonly WEARABLE: Internal.EnchantmentCategory;
        static readonly DIGGER: Internal.EnchantmentCategory;
        static readonly FISHING_ROD: Internal.EnchantmentCategory;
        static readonly VANISHABLE: Internal.EnchantmentCategory;
    }
    type EnchantmentCategory_ = "armor_head" | "armor_legs" | "crossbow" | "vanishable" | "armor_chest" | "breakable" | "fishing_rod" | "trident" | "digger" | "wearable" | "weapon" | "armor" | "bow" | "armor_feet" | EnchantmentCategory;
    class JournalItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static getJournalData(journal: Internal.ItemStack_): Internal.JournalData;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        static researchPlant(journal: Internal.ItemStack_, plantId: ResourceLocation_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static getResearchedPlants(journal: Internal.ItemStack_): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type JournalItem_ = JournalItem;
    interface IWeaponAttack extends Internal.GenericLoaderRegistry$IHaveLoader<Internal.IWeaponAttack> {
        abstract dealDamage(arg0: Internal.IToolStackView_, arg1: Internal.ToolAttackContext_, arg2: number): boolean;
        abstract getLoader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IWeaponAttack>;
        get loader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IWeaponAttack>
        readonly DEFAULT: Internal.IWeaponAttack;
        readonly LOADER: Internal.GenericLoaderRegistry<Internal.IWeaponAttack>;
    }
    type IWeaponAttack_ = IWeaponAttack;
    class BedItem extends Internal.BlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BedItem_ = BedItem;
    class ClientboundSetBorderWarningDelayPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        getWarningDelay(): number;
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get warningDelay(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderWarningDelayPacket_ = ClientboundSetBorderWarningDelayPacket;
    interface IPriorityHost extends Internal.ISubMenuHost {
        abstract setPriority(arg0: number): void;
        abstract getPriority(): number;
        abstract getMainMenuIcon(): Internal.ItemStack;
        abstract returnToMainMenu(arg0: Internal.Player_, arg1: Internal.ISubMenu_): void;
        set priority(arg0: number)
        get priority(): number
        get mainMenuIcon(): Internal.ItemStack
    }
    type IPriorityHost_ = IPriorityHost;
    class OriginGrassBlock extends Internal.GrassBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type OriginGrassBlock_ = OriginGrassBlock;
    class PrintWriter extends Internal.Writer {
        constructor(arg0: Internal.File_)
        constructor(arg0: Internal.OutputStream_, arg1: boolean)
        constructor(arg0: Internal.OutputStream_)
        constructor(arg0: string, arg1: string)
        constructor(arg0: string, arg1: Internal.Charset_)
        constructor(arg0: Internal.File_, arg1: Internal.Charset_)
        constructor(arg0: Internal.Writer_, arg1: boolean)
        constructor(arg0: Internal.Writer_)
        constructor(arg0: Internal.OutputStream_, arg1: boolean, arg2: Internal.Charset_)
        constructor(arg0: string)
        constructor(arg0: Internal.File_, arg1: string)
        print(arg0: string): void;
        println(arg0: number): void;
        println(): void;
        format(arg0: Internal.Locale_, arg1: string, ...arg2: any[]): this;
        println(arg0: number): void;
        print(arg0: number): void;
        println(arg0: string): void;
        print(arg0: number): void;
        printf(arg0: string, ...arg1: any[]): this;
        print(arg0: number): void;
        print(arg0: boolean): void;
        printf(arg0: Internal.Locale_, arg1: string, ...arg2: any[]): this;
        println(arg0: string): void;
        println(arg0: string[]): void;
        println(arg0: boolean): void;
        append(arg0: Internal.CharSequence_): Internal.Appendable;
        println(arg0: number): void;
        println(arg0: number): void;
        checkError(): boolean;
        print(arg0: any): void;
        print(arg0: string[]): void;
        print(arg0: string): void;
        format(arg0: string, ...arg1: any[]): this;
        print(arg0: number): void;
        println(arg0: any): void;
    }
    type PrintWriter_ = PrintWriter;
    class EnumConfig <E> extends Internal.ConfigWithVariants<E> {
        constructor(nm: Internal.NameMap_<E>)
        getIteration(currentValue: E, next: boolean): E;
        readonly nameMap: Internal.NameMap<E>;
    }
    type EnumConfig_<E> = EnumConfig<E>;
    class FacingOrNone extends Internal.Enum<Internal.FacingOrNone> implements Internal.StringRepresentable {
        static "with"(direction: Internal.Direction_): Internal.FacingOrNone;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.FacingOrNone[];
        getSerializedName(): string;
        static valueOf(name: string): Internal.FacingOrNone;
        getDirection(): Internal.Direction;
        get serializedName(): string
        get direction(): Internal.Direction
        static readonly EAST: Internal.FacingOrNone;
        static readonly WEST: Internal.FacingOrNone;
        static readonly DOWN: Internal.FacingOrNone;
        static readonly NORTH: Internal.FacingOrNone;
        static readonly SOUTH: Internal.FacingOrNone;
        static readonly BLOCK_PROPERTY: Internal.EnumProperty<Internal.FacingOrNone>;
        static readonly UP: Internal.FacingOrNone;
        static readonly NONE: Internal.FacingOrNone;
    }
    type FacingOrNone_ = "west" | "east" | "south" | "up" | "down" | FacingOrNone | "north" | "none";
    abstract class BlockAbstractImpetus extends Internal.BlockCircleComponent implements Internal.EntityBlock {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        abstract newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockAbstractImpetus_ = BlockAbstractImpetus;
    class QuantumLinkChamberBlock extends Internal.QuantumBaseBlock {
        constructor()
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type QuantumLinkChamberBlock_ = QuantumLinkChamberBlock;
    abstract class EntityEvents extends Internal.BaseEvent {
        constructor(entity: Internal.Entity_)
        getEntity(): Internal.Entity;
        get entity(): Internal.Entity
        /**
         * @deprecated
         * This field is marked to be removed in future!
        */
        static readonly STRUCK_BY_LIGHTING: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$LightingStrike>;
        static readonly ON_REMOVE: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$Remove>;
        static readonly PROJECTILE_IMPACT: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$ProjectileImpact>;
        /**
         * @deprecated
         * This field is marked to be removed in future!
        */
        static readonly EYE_HEIGHT: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$EyeHeight>;
        static readonly START_TRACKING_TAIL: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$Tracking>;
        static readonly SIZE: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$EntitySize>;
        static readonly ENTITY_STRUCK_BY_LIGHTING: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$NewLightingStrike>;
        static readonly ON_JOIN_WORLD: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$JoinWorld>;
        static readonly TELEPORT: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$Teleport>;
        static readonly ENTERING_SECTION: net.fabricmc.fabric.api.event.Event<Internal.EntityEvents$EnteringSection>;
    }
    type EntityEvents_ = EntityEvents;
    class PiggyBackPackItem$CarryPotionEffect extends Internal.TinkerEffect {
        constructor()
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        get curativeItems(): Internal.List<Internal.ItemStack>
    }
    type PiggyBackPackItem$CarryPotionEffect_ = PiggyBackPackItem$CarryPotionEffect;
    class DiggingEnchantment extends Internal.Enchantment {
    }
    type DiggingEnchantment_ = DiggingEnchantment;
    abstract class Component implements Internal.MenuContainer, Internal.ImageObserver, Internal.Serializable {
        getHierarchyListeners(): Internal.HierarchyListener[];
        getLocationOnScreen(): Internal.Point;
        getHierarchyBoundsListeners(): Internal.HierarchyBoundsListener[];
        getY(): number;
        getParent(): Internal.Container;
        setFont(arg0: Internal.Font_): void;
        firePropertyChange(arg0: string, arg1: string, arg2: string): void;
        getDropTarget(): Internal.DropTarget;
        removeComponentListener(arg0: Internal.ComponentListener_): void;
        isOpaque(): boolean;
        setName(arg0: string): void;
        setForeground(arg0: Internal.Color_): void;
        getBackground(): Internal.Color;
        requestFocusInWindow(): boolean;
        setCursor(arg0: Internal.Cursor_): void;
        /**
         * @deprecated
        */
        show(arg0: boolean): void;
        isValid(): boolean;
        firePropertyChange(arg0: string, arg1: number, arg2: number): void;
        checkImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.ImageObserver_): number;
        paintAll(arg0: Internal.Graphics_): void;
        isFontSet(): boolean;
        /**
         * @deprecated
        */
        mouseUp(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        removePropertyChangeListener(arg0: Internal.PropertyChangeListener_): void;
        addMouseMotionListener(arg0: Internal.MouseMotionListener_): void;
        getX(): number;
        addKeyListener(arg0: Internal.KeyListener_): void;
        removeKeyListener(arg0: Internal.KeyListener_): void;
        update(arg0: Internal.Graphics_): void;
        getFont(): Internal.Font;
        getName(): string;
        validate(): void;
        getAlignmentY(): number;
        /**
         * @deprecated
        */
        mouseDrag(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        setIgnoreRepaint(arg0: boolean): void;
        getHeight(): number;
        addComponentListener(arg0: Internal.ComponentListener_): void;
        addNotify(): void;
        hasFocus(): boolean;
        setSize(arg0: Internal.Dimension_): void;
        addMouseListener(arg0: Internal.MouseListener_): void;
        isShowing(): boolean;
        removeNotify(): void;
        /**
         * @deprecated
        */
        keyUp(arg0: Internal.Event_, arg1: number): boolean;
        getCursor(): Internal.Cursor;
        prepareImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.ImageObserver_): boolean;
        getBaselineResizeBehavior(): Internal.Component$BaselineResizeBehavior;
        addInputMethodListener(arg0: Internal.InputMethodListener_): void;
        addMouseWheelListener(arg0: Internal.MouseWheelListener_): void;
        dispatchEvent(arg0: Internal.AWTEvent_): void;
        getGraphicsConfiguration(): Internal.GraphicsConfiguration;
        setLocation(arg0: Internal.Point_): void;
        createImage(arg0: Internal.ImageProducer_): Internal.Image;
        /**
         * @deprecated
        */
        postEvent(arg0: Internal.Event_): boolean;
        repaint(arg0: number, arg1: number, arg2: number, arg3: number): void;
        requestFocus(arg0: Internal.FocusEvent$Cause_): void;
        /**
         * @deprecated
        */
        keyDown(arg0: Internal.Event_, arg1: number): boolean;
        firePropertyChange(arg0: string, arg1: number, arg2: number): void;
        checkImage(arg0: Internal.Image_, arg1: Internal.ImageObserver_): number;
        setMaximumSize(arg0: Internal.Dimension_): void;
        removeMouseListener(arg0: Internal.MouseListener_): void;
        getComponentAt(arg0: Internal.Point_): this;
        getIgnoreRepaint(): boolean;
        removeMouseMotionListener(arg0: Internal.MouseMotionListener_): void;
        getMouseWheelListeners(): Internal.MouseWheelListener[];
        /**
         * @deprecated
        */
        action(arg0: Internal.Event_, arg1: any): boolean;
        /**
         * @deprecated
        */
        locate(arg0: number, arg1: number): this;
        print(arg0: Internal.Graphics_): void;
        removePropertyChangeListener(arg0: string, arg1: Internal.PropertyChangeListener_): void;
        getComponentListeners(): Internal.ComponentListener[];
        setDropTarget(arg0: Internal.DropTarget_): void;
        getListeners<T extends Internal.EventListener>(arg0: T): T[];
        enableInputMethods(arg0: boolean): void;
        getInputContext(): Internal.InputContext;
        getFontMetrics(arg0: Internal.Font_): Internal.FontMetrics;
        revalidate(): void;
        /**
         * @deprecated
        */
        resize(arg0: Internal.Dimension_): void;
        isDoubleBuffered(): boolean;
        addHierarchyBoundsListener(arg0: Internal.HierarchyBoundsListener_): void;
        setBounds(arg0: Internal.Rectangle_): void;
        /**
         * @deprecated
        */
        handleEvent(arg0: Internal.Event_): boolean;
        getLocation(): Internal.Point;
        /**
         * @deprecated
        */
        move(arg0: number, arg1: number): void;
        getInputMethodRequests(): Internal.InputMethodRequests;
        remove(arg0: Internal.MenuComponent_): void;
        /**
         * @deprecated
        */
        location(): Internal.Point;
        createVolatileImage(arg0: number, arg1: number, arg2: Internal.ImageCapabilities_): Internal.VolatileImage;
        /**
         * @deprecated
        */
        inside(arg0: number, arg1: number): boolean;
        /**
         * @deprecated
        */
        enable(): void;
        /**
         * @deprecated
        */
        lostFocus(arg0: Internal.Event_, arg1: any): boolean;
        isCursorSet(): boolean;
        list(arg0: Internal.PrintStream_, arg1: number): void;
        /**
         * @deprecated
        */
        mouseMove(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        addFocusListener(arg0: Internal.FocusListener_): void;
        setFocusTraversalKeysEnabled(arg0: boolean): void;
        firePropertyChange(arg0: string, arg1: number, arg2: number): void;
        getBounds(): Internal.Rectangle;
        contains(arg0: Internal.Point_): boolean;
        setEnabled(arg0: boolean): void;
        removeInputMethodListener(arg0: Internal.InputMethodListener_): void;
        transferFocusBackward(): void;
        /**
         * @deprecated
        */
        nextFocus(): void;
        imageUpdate(arg0: Internal.Image_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
        /**
         * @deprecated
        */
        mouseEnter(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        getFocusListeners(): Internal.FocusListener[];
        removeHierarchyBoundsListener(arg0: Internal.HierarchyBoundsListener_): void;
        getKeyListeners(): Internal.KeyListener[];
        getComponentOrientation(): Internal.ComponentOrientation;
        list(arg0: Internal.PrintWriter_, arg1: number): void;
        requestFocus(): void;
        applyComponentOrientation(arg0: Internal.ComponentOrientation_): void;
        getToolkit(): Internal.Toolkit;
        getWidth(): number;
        getBounds(arg0: Internal.Rectangle_): Internal.Rectangle;
        paint(arg0: Internal.Graphics_): void;
        removeHierarchyListener(arg0: Internal.HierarchyListener_): void;
        list(arg0: Internal.PrintStream_): void;
        transferFocus(): void;
        requestFocusInWindow(arg0: Internal.FocusEvent$Cause_): boolean;
        /**
         * @deprecated
        */
        deliverEvent(arg0: Internal.Event_): void;
        getPreferredSize(): Internal.Dimension;
        setMinimumSize(arg0: Internal.Dimension_): void;
        createVolatileImage(arg0: number, arg1: number): Internal.VolatileImage;
        /**
         * @deprecated
        */
        resize(arg0: number, arg1: number): void;
        removeFocusListener(arg0: Internal.FocusListener_): void;
        getMouseListeners(): Internal.MouseListener[];
        firePropertyChange(arg0: string, arg1: number, arg2: number): void;
        list(arg0: Internal.PrintWriter_): void;
        repaint(arg0: number): void;
        /**
         * @deprecated
        */
        gotFocus(arg0: Internal.Event_, arg1: any): boolean;
        getSize(): Internal.Dimension;
        getForeground(): Internal.Color;
        addPropertyChangeListener(arg0: string, arg1: Internal.PropertyChangeListener_): void;
        /**
         * @deprecated
        */
        hide(): void;
        isPreferredSizeSet(): boolean;
        getInputMethodListeners(): Internal.InputMethodListener[];
        /**
         * @deprecated
        */
        enable(arg0: boolean): void;
        getLocation(arg0: Internal.Point_): Internal.Point;
        createImage(arg0: number, arg1: number): Internal.Image;
        isFocusable(): boolean;
        setSize(arg0: number, arg1: number): void;
        getPropertyChangeListeners(arg0: string): Internal.PropertyChangeListener[];
        printAll(arg0: Internal.Graphics_): void;
        getGraphics(): Internal.Graphics;
        removeMouseWheelListener(arg0: Internal.MouseWheelListener_): void;
        /**
         * @deprecated
        */
        reshape(arg0: number, arg1: number, arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        minimumSize(): Internal.Dimension;
        invalidate(): void;
        addHierarchyListener(arg0: Internal.HierarchyListener_): void;
        contains(arg0: number, arg1: number): boolean;
        isFocusCycleRoot(arg0: Internal.Container_): boolean;
        setBackground(arg0: Internal.Color_): void;
        transferFocusUpCycle(): void;
        addPropertyChangeListener(arg0: Internal.PropertyChangeListener_): void;
        setBounds(arg0: number, arg1: number, arg2: number, arg3: number): void;
        setVisible(arg0: boolean): void;
        /**
         * @deprecated
        */
        mouseExit(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        firePropertyChange(arg0: string, arg1: number, arg2: number): void;
        /**
         * @deprecated
        */
        isFocusTraversable(): boolean;
        /**
         * @deprecated
        */
        preferredSize(): Internal.Dimension;
        /**
         * @deprecated
        */
        show(): void;
        getMouseMotionListeners(): Internal.MouseMotionListener[];
        getFocusTraversalKeysEnabled(): boolean;
        isFocusOwner(): boolean;
        getPropertyChangeListeners(): Internal.PropertyChangeListener[];
        getAlignmentX(): number;
        getBaseline(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        bounds(): Internal.Rectangle;
        /**
         * @deprecated
        */
        layout(): void;
        isVisible(): boolean;
        /**
         * @deprecated
        */
        size(): Internal.Dimension;
        areFocusTraversalKeysSet(arg0: number): boolean;
        setPreferredSize(arg0: Internal.Dimension_): void;
        isMaximumSizeSet(): boolean;
        getLocale(): Internal.Locale;
        repaint(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        isMinimumSizeSet(): boolean;
        add(arg0: Internal.PopupMenu_): void;
        isBackgroundSet(): boolean;
        getMinimumSize(): Internal.Dimension;
        repaint(): void;
        /**
         * @deprecated
        */
        disable(): void;
        setLocale(arg0: Internal.Locale_): void;
        setFocusTraversalKeys(arg0: number, arg1: Internal.Set_<Internal.AWTKeyStroke>): void;
        setMixingCutoutShape(arg0: Internal.Shape_): void;
        getMousePosition(): Internal.Point;
        isEnabled(): boolean;
        getMaximumSize(): Internal.Dimension;
        list(): void;
        /**
         * @deprecated
        */
        mouseDown(arg0: Internal.Event_, arg1: number, arg2: number): boolean;
        isForegroundSet(): boolean;
        setComponentOrientation(arg0: Internal.ComponentOrientation_): void;
        getSize(arg0: Internal.Dimension_): Internal.Dimension;
        getColorModel(): Internal.ColorModel;
        getTreeLock(): any;
        prepareImage(arg0: Internal.Image_, arg1: Internal.ImageObserver_): boolean;
        getAccessibleContext(): Internal.AccessibleContext;
        isLightweight(): boolean;
        getFocusTraversalKeys(arg0: number): Internal.Set<Internal.AWTKeyStroke>;
        getComponentAt(arg0: number, arg1: number): this;
        doLayout(): void;
        isDisplayable(): boolean;
        setLocation(arg0: number, arg1: number): void;
        getFocusCycleRootAncestor(): Internal.Container;
        setFocusable(arg0: boolean): void;
        get hierarchyListeners(): Internal.HierarchyListener[]
        get locationOnScreen(): Internal.Point
        get hierarchyBoundsListeners(): Internal.HierarchyBoundsListener[]
        get y(): number
        get parent(): Internal.Container
        set font(arg0: Internal.Font_)
        get dropTarget(): Internal.DropTarget
        get opaque(): boolean
        set name(arg0: string)
        set foreground(arg0: Internal.Color_)
        get background(): Internal.Color
        set cursor(arg0: Internal.Cursor_)
        get valid(): boolean
        get fontSet(): boolean
        get x(): number
        get font(): Internal.Font
        get name(): string
        get alignmentY(): number
        set ignoreRepaint(arg0: boolean)
        get height(): number
        set size(arg0: Internal.Dimension_)
        get showing(): boolean
        get cursor(): Internal.Cursor
        get baselineResizeBehavior(): Internal.Component$BaselineResizeBehavior
        get graphicsConfiguration(): Internal.GraphicsConfiguration
        set location(arg0: Internal.Point_)
        set maximumSize(arg0: Internal.Dimension_)
        get ignoreRepaint(): boolean
        get mouseWheelListeners(): Internal.MouseWheelListener[]
        get componentListeners(): Internal.ComponentListener[]
        set dropTarget(arg0: Internal.DropTarget_)
        get inputContext(): Internal.InputContext
        get doubleBuffered(): boolean
        set bounds(arg0: Internal.Rectangle_)
        get location(): Internal.Point
        get inputMethodRequests(): Internal.InputMethodRequests
        get cursorSet(): boolean
        set focusTraversalKeysEnabled(arg0: boolean)
        get bounds(): Internal.Rectangle
        set enabled(arg0: boolean)
        get focusListeners(): Internal.FocusListener[]
        get keyListeners(): Internal.KeyListener[]
        get componentOrientation(): Internal.ComponentOrientation
        get toolkit(): Internal.Toolkit
        get width(): number
        get preferredSize(): Internal.Dimension
        set minimumSize(arg0: Internal.Dimension_)
        get mouseListeners(): Internal.MouseListener[]
        get size(): Internal.Dimension
        get foreground(): Internal.Color
        get preferredSizeSet(): boolean
        get inputMethodListeners(): Internal.InputMethodListener[]
        get focusable(): boolean
        get graphics(): Internal.Graphics
        set background(arg0: Internal.Color_)
        set visible(arg0: boolean)
        /**
         * @deprecated
        */
        get focusTraversable(): boolean
        get mouseMotionListeners(): Internal.MouseMotionListener[]
        get focusTraversalKeysEnabled(): boolean
        get focusOwner(): boolean
        get propertyChangeListeners(): Internal.PropertyChangeListener[]
        get alignmentX(): number
        get visible(): boolean
        set preferredSize(arg0: Internal.Dimension_)
        get maximumSizeSet(): boolean
        get locale(): Internal.Locale
        get minimumSizeSet(): boolean
        get backgroundSet(): boolean
        get minimumSize(): Internal.Dimension
        set locale(arg0: Internal.Locale_)
        set mixingCutoutShape(arg0: Internal.Shape_)
        get mousePosition(): Internal.Point
        get enabled(): boolean
        get maximumSize(): Internal.Dimension
        get foregroundSet(): boolean
        set componentOrientation(arg0: Internal.ComponentOrientation_)
        get colorModel(): Internal.ColorModel
        get treeLock(): any
        get accessibleContext(): Internal.AccessibleContext
        get lightweight(): boolean
        get displayable(): boolean
        get focusCycleRootAncestor(): Internal.Container
        set focusable(arg0: boolean)
        static readonly RIGHT_ALIGNMENT: 1.0;
        static readonly BOTTOM_ALIGNMENT: 1.0;
        static readonly LEFT_ALIGNMENT: 0.0;
        static readonly TOP_ALIGNMENT: 0.0;
        static readonly CENTER_ALIGNMENT: 0.5;
    }
    type Component_ = Component;
    abstract class AbstractBellBlock <BE extends Internal.AbstractBellBlockEntity> extends Internal.BellBlock implements Internal.IBE<BE> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        abstract playSound(arg0: Internal.Level_, arg1: BlockPos_): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<BE>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(p_152194_: Internal.Level_, p_152195_: Internal.BlockState_, p_152196_: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<BE>): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        abstract getBlockEntityClass(): BE;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<BE, Internal.InteractionResult>): Internal.InteractionResult;
        abstract getBlockEntityType(): Internal.BlockEntityType<BE>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        canRingFrom(state: Internal.BlockState_, hitDir: Internal.Direction_, heightChange: number): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): BE;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): BE
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<BE>
    }
    type AbstractBellBlock_<BE extends Internal.AbstractBellBlockEntity> = AbstractBellBlock<BE>;
    interface ObjectBidirectionalIterator <K> extends Internal.ObjectIterator<K>, Internal.BidirectionalIterator<K> {
        abstract hasPrevious(): boolean;
        remove(): void;
        skip(arg0: number): number;
        abstract next(): K;
        back(arg0: number): number;
        abstract hasNext(): boolean;
        forEachRemaining(arg0: Internal.Consumer_<K>): void;
        abstract previous(): K;
    }
    type ObjectBidirectionalIterator_<K> = ObjectBidirectionalIterator<K>;
    class FireworksJS$Shape extends Internal.Enum<Internal.FireworksJS$Shape> {
        static values(): Internal.FireworksJS$Shape[];
        static valueOf(name: string): Internal.FireworksJS$Shape;
        static get(name: string): Internal.FireworksJS$Shape;
        static readonly CREEPER: Internal.FireworksJS$Shape;
        readonly type: number;
        static readonly LARGE_BALL: Internal.FireworksJS$Shape;
        static readonly VALUES: Internal.FireworksJS$Shape[];
        static readonly BURST: Internal.FireworksJS$Shape;
        static readonly STAR: Internal.FireworksJS$Shape;
        static readonly SMALL_BALL: Internal.FireworksJS$Shape;
    }
    type FireworksJS$Shape_ = "star" | "burst" | FireworksJS$Shape | "large_ball" | "creeper" | "small_ball";
    interface ChunkBufferBuilderPackAccessor {
        abstract getField_3951(): Internal.Map<Internal.RenderType, Internal.BufferBuilder>;
        get field_3951(): Internal.Map<Internal.RenderType, Internal.BufferBuilder>
        (): Internal.Map_<Internal.RenderType, Internal.BufferBuilder>;
    }
    type ChunkBufferBuilderPackAccessor_ = ChunkBufferBuilderPackAccessor;
    class Vec3Arithmetic extends Internal.Enum<Internal.Vec3Arithmetic> implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        static make2Vec(pattern: Internal.HexPattern_, op: Internal.BiFunction_<Vec3d, Vec3d, Vec3d>): Internal.OperatorVec3Delegating;
        static valueOf(name: string): Internal.Vec3Arithmetic;
        opTypes(): Internal.Iterable<Internal.HexPattern>;
        arithName(): string;
        static make2Fallback(pattern: Internal.HexPattern_): Internal.OperatorVec3Delegating;
        static make1Double(op: Internal.Function_<Vec3d, number>): Internal.OperatorUnary;
        static values(): Internal.Vec3Arithmetic[];
        static make2Double(pattern: Internal.HexPattern_, op: Internal.BiFunction_<Vec3d, Vec3d, number>): Internal.OperatorVec3Delegating;
        static make1(op: Internal.Function_<Vec3d, Vec3d>): Internal.OperatorUnary;
        static readonly INSTANCE: Internal.Vec3Arithmetic;
        static readonly ACCEPTS: Internal.IotaMultiPredicate$Any;
        static readonly OPS: [Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern];
    }
    type Vec3Arithmetic_ = Vec3Arithmetic | "instance";
    class MoltenBismuthFluid$Flowing extends Internal.MoltenBismuthFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBismuthFluid$Flowing_ = MoltenBismuthFluid$Flowing;
    class ServerboundInteractPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        static createAttackPacket($$0: Internal.Entity_, $$1: boolean): Internal.ServerboundInteractPacket;
        write($$0: Internal.FriendlyByteBuf_): void;
        static createInteractionPacket($$0: Internal.Entity_, $$1: boolean, $$2: Internal.InteractionHand_): Internal.ServerboundInteractPacket;
        handle($$0: Internal.ServerGamePacketListener_): void;
        dispatch($$0: Internal.ServerboundInteractPacket$Handler_): void;
        static createInteractionPacket($$0: Internal.Entity_, $$1: boolean, $$2: Internal.InteractionHand_, $$3: Vec3d_): Internal.ServerboundInteractPacket;
        getTarget($$0: Internal.ServerLevel_): Internal.Entity;
        isSkippable(): boolean;
        isUsingSecondaryAction(): boolean;
        get skippable(): boolean
        get usingSecondaryAction(): boolean
    }
    type ServerboundInteractPacket_ = ServerboundInteractPacket;
    abstract class VehicleItem extends Internal.RenderedItem implements Internal.BotariumFluidItem<Internal.WrappedItemFluidContainer> {
        constructor(type: Internal.Supplier_<Internal.EntityType<any>>, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getFluidContainer(holder: Internal.ItemStack_): Internal.WrappedItemFluidContainer;
        type(): Internal.EntityType<any>;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type VehicleItem_ = VehicleItem;
    class MoltenSteelFluid$Flowing extends Internal.MoltenSteelFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenSteelFluid$Flowing_ = MoltenSteelFluid$Flowing;
    class SkilletBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntity: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        static getSkilletCookingTime(originalCookingTime: number, fireAspectLevel: number): number;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MINIMUM_COOKING_TIME: 60;
        static readonly SUPPORT: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type SkilletBlock_ = SkilletBlock;
    class CarriageParticles {
        constructor(entity: Internal.CarriageContraptionEntity_)
        tick(dce: Internal.Carriage$DimensionalCarriageEntity_): void;
    }
    type CarriageParticles_ = CarriageParticles;
    class PingResult extends Internal.ValueObject implements Internal.ReflectionBasedSerialization {
        constructor()
        pingResults: Internal.List<Internal.RegionPingResult>;
        worldIds: Internal.List<number>;
    }
    type PingResult_ = PingResult;
}
declare namespace dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io {
    class WritingMode extends Internal.Enum<dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode> {
        static values(): dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode[];
        static valueOf(name: string): dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode;
        static readonly REPLACE: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode;
        static readonly APPEND: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode;
        static readonly REPLACE_ATOMIC: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.io.WritingMode;
    }
    type WritingMode_ = "replace" | WritingMode | "append" | "replace_atomic";
}
declare namespace net.createmod.catnip.theme {
    class Color {
        constructor(r: number, g: number, b: number)
        constructor(argb: number, hasAlpha: boolean)
        constructor(r: number, g: number, b: number, a: number)
        constructor(argb: number)
        constructor(r: number, g: number, b: number, a: number)
        modifyValue(function_: Internal.UnaryOperator_<number>): this;
        static mixColors(c1: net.createmod.catnip.theme.Color_, c2: net.createmod.catnip.theme.Color_, w: number): net.createmod.catnip.theme.Color;
        getAlphaAsFloat(): number;
        setBlue(b: number): this;
        setValue(value: number): this;
        getAlpha(): number;
        getBlueAsFloat(): number;
        setRed(r: number): this;
        setAlpha(a: number): this;
        static generateFromLong(l: number): net.createmod.catnip.theme.Color;
        asVectorF(): Vec3f;
        copy(mutable: boolean): this;
        setAlpha(a: number): this;
        setImmutable(): this;
        getGreenAsFloat(): number;
        setBlue(b: number): this;
        brighter(): this;
        static mixColors(color1: number, color2: number, w: number): number;
        getBlue(): number;
        getGreen(): number;
        asStyle(): Internal.Style;
        setGreen(g: number): this;
        getRGB(): number;
        copy(): this;
        scaleAlpha(factor: number): this;
        static mixColors(colors: Internal.Couple_<net.createmod.catnip.theme.Color>, w: number): net.createmod.catnip.theme.Color;
        ensureMutable(): this;
        setGreen(g: number): this;
        getRed(): number;
        getRedAsFloat(): number;
        static rainbowColor(timeStep: number): net.createmod.catnip.theme.Color;
        scaleAlphaForText(factor: number): this;
        asVector(): Vec3d;
        darker(): this;
        mixWith(other: net.createmod.catnip.theme.Color_, weight: number): this;
        setRed(r: number): this;
        get alphaAsFloat(): number
        set blue(b: number)
        set value(value: number)
        get alpha(): number
        get blueAsFloat(): number
        set red(r: number)
        set alpha(a: number)
        set alpha(a: number)
        get greenAsFloat(): number
        set blue(b: number)
        get blue(): number
        get green(): number
        set green(g: number)
        get RGB(): number
        set green(g: number)
        get red(): number
        get redAsFloat(): number
        set red(r: number)
        static readonly RED: net.createmod.catnip.theme.Color;
        static readonly PURPLE: net.createmod.catnip.theme.Color;
        static readonly BLACK: net.createmod.catnip.theme.Color;
        static readonly GREEN: net.createmod.catnip.theme.Color;
        static readonly SPRING_GREEN: net.createmod.catnip.theme.Color;
        static readonly TRANSPARENT_BLACK: net.createmod.catnip.theme.Color;
        static readonly WHITE: net.createmod.catnip.theme.Color;
    }
    type Color_ = Color;
}
